package com.elitescloud.cloudt.authorization.api.client.config;

import com.elitescloud.cloudt.authorization.api.client.client.config.OAuthClientProperties;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 认证相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/12/31
 */
@ConfigurationProperties(prefix = AuthorizationProperties.CONFIG_PREFIX)
public class AuthorizationProperties {

    public static final String CONFIG_PREFIX = "elitesland.authorization";

    /**
     * 是否启用安全认证
     */
    private Boolean enabled = true;

    /**
     * 认证方式
     */
    private AuthorizationType type = AuthorizationType.SINGLE;

    /**
     * token生成时的有效期
     */
    private Duration tokenTtl = Duration.ofMinutes(30);

    /**
     * token自动续期时长，小于1时将不自动续期
     */
    private Duration tokenRenewal = Duration.ofMinutes(30);

    /**
     * token刷新频率，tokenRenewalRate * 2必须小于tokenRenewal
     */
    private Duration tokenRenewalRate = Duration.ofMillis(10);

    /**
     * 是否允许匿名访问
     */
    private Boolean anonymousEnabled = false;

    /**
     * 白名单，不允许匿名访问时有效
     */
    private Set<String> allowList = new HashSet<>(8);

    /**
     * 黑名单，允许匿名反问时有效
     */
    private Set<String> rejectList = new HashSet<>(8);

    /**
     * 是否启用csrf
     */
    private Boolean csrfEnabled = false;

    /**
     * 是否启用cors
     */
    private Boolean corsEnabled = false;

    /**
     * 启用cors时有效的配置
     */
    private List<CorsConfig> cors = new ArrayList<>();

    /**
     * OAuth2客户端
     */
    private final OAuth2Client oauth2Client = new OAuth2Client();

    /**
     * 外部OAuth2客户端
     */
    private final List<OAuth2Client> externalOauth2Clients = new ArrayList<>();

    /**
     * 客户端配置
     */
    @NestedConfigurationProperty
    private final OAuthClientProperties client = new OAuthClientProperties();

    /**
     * 角色前缀
     */
    private String rolePrefix = "ROLE_";

    /**
     * 登录页
     */
    private String loginPage = null;

    /**
     * 重定向的路径前缀，nginx类代理导致重定向失败时的策略
     */
    private String redirectUriPrefix = null;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AuthorizationType getType() {
        return type;
    }

    public void setType(AuthorizationType type) {
        this.type = type;
    }

    public Duration getTokenTtl() {
        return tokenTtl;
    }

    public void setTokenTtl(Duration tokenTtl) {
        this.tokenTtl = tokenTtl;
    }

    public Duration getTokenRenewal() {
        return tokenRenewal;
    }

    public void setTokenRenewal(Duration tokenRenewal) {
        this.tokenRenewal = tokenRenewal;
    }

    public Duration getTokenRenewalRate() {
        return tokenRenewalRate;
    }

    public void setTokenRenewalRate(Duration tokenRenewalRate) {
        this.tokenRenewalRate = tokenRenewalRate;
    }

    public Boolean getAnonymousEnabled() {
        return anonymousEnabled;
    }

    public void setAnonymousEnabled(Boolean anonymousEnabled) {
        this.anonymousEnabled = anonymousEnabled;
    }

    public Set<String> getAllowList() {
        return allowList;
    }

    public void setAllowList(Set<String> allowList) {
        this.allowList = allowList;
    }

    public Set<String> getRejectList() {
        return rejectList;
    }

    public void setRejectList(Set<String> rejectList) {
        this.rejectList = rejectList;
    }

    public Boolean getCsrfEnabled() {
        return csrfEnabled;
    }

    public void setCsrfEnabled(Boolean csrfEnabled) {
        this.csrfEnabled = csrfEnabled;
    }

    public Boolean getCorsEnabled() {
        return corsEnabled;
    }

    public void setCorsEnabled(Boolean corsEnabled) {
        this.corsEnabled = corsEnabled;
    }

    public List<CorsConfig> getCors() {
        return cors;
    }

    public void setCors(List<CorsConfig> cors) {
        this.cors = cors;
    }

    public OAuth2Client getOauth2Client() {
        return oauth2Client;
    }

    public List<OAuth2Client> getExternalOauth2Clients() {
        return externalOauth2Clients;
    }

    public OAuthClientProperties getClient() {
        return client;
    }

    public String getRolePrefix() {
        return rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public String getLoginPage() {
        return loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public String getRedirectUriPrefix() {
        return redirectUriPrefix;
    }

    public void setRedirectUriPrefix(String redirectUriPrefix) {
        this.redirectUriPrefix = redirectUriPrefix;
    }

    public static class OAuth2Client {

        /**
         * 服务端地址
         */
        private String serverAddress;
        /**
         * 客户端ID
         */
        private String clientId;
        /**
         * 客户端secret
         */
        private String clientSecret;
        /**
         * 服务端认证地址
         */
        private String authorizeEndpoint;
        /**
         * 服务端生成token地址
         */
        private String tokenEndpoint;
        /**
         * 用户信息地址
         */
        private String userinfoEndpoint;
        /**
         * 客户端名称
         */
        private String clientName;
        /**
         * 客户端图标
         */
        private String clientIcon;

        public String getServerAddress() {
            return serverAddress;
        }

        public void setServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
        }

        public String getClientId() {
            return clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getAuthorizeEndpoint() {
            return authorizeEndpoint;
        }

        public void setAuthorizeEndpoint(String authorizeEndpoint) {
            this.authorizeEndpoint = authorizeEndpoint;
        }

        public String getTokenEndpoint() {
            return tokenEndpoint;
        }

        public void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        public String getUserinfoEndpoint() {
            return userinfoEndpoint;
        }

        public void setUserinfoEndpoint(String userinfoEndpoint) {
            this.userinfoEndpoint = userinfoEndpoint;
        }

        public String getClientName() {
            return clientName;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public String getClientIcon() {
            return clientIcon;
        }

        public void setClientIcon(String clientIcon) {
            this.clientIcon = clientIcon;
        }
    }

    public static class CorsConfig {
        /**
         * 匹配的路径，默认所有
         */
        private String pathMatcher = "/**";
        /**
         * 允许的源模式
         */
        private Set<String> allowedOriginPatterns = new HashSet<>();

        /**
         * 允许的源
         */
        private Set<String> allowedOrigins = new HashSet<>();

        /**
         * 允许的头
         */
        private Set<String> allowedHeaders = new HashSet<>();

        /**
         * 允许的方法
         */
        private Set<String> allowedMethods = new HashSet<>();

        /**
         * 是否信任的
         */
        private boolean allowCredentials;

        public String getPathMatcher() {
            return pathMatcher;
        }

        public void setPathMatcher(String pathMatcher) {
            this.pathMatcher = pathMatcher;
        }

        public Set<String> getAllowedOriginPatterns() {
            return allowedOriginPatterns;
        }

        public void setAllowedOriginPatterns(Set<String> allowedOriginPatterns) {
            this.allowedOriginPatterns = allowedOriginPatterns;
        }

        public Set<String> getAllowedOrigins() {
            return allowedOrigins;
        }

        public void setAllowedOrigins(Set<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public Set<String> getAllowedHeaders() {
            return allowedHeaders;
        }

        public void setAllowedHeaders(Set<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        public Set<String> getAllowedMethods() {
            return allowedMethods;
        }

        public void setAllowedMethods(Set<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public boolean isAllowCredentials() {
            return allowCredentials;
        }

        public void setAllowCredentials(boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }
    }
}
