package com.elitescloud.cloudt.authorization.api.client.config.security.configurer.filter;

import com.elitescloud.cloudt.authorization.api.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.cloudt.authorization.api.client.config.security.resolver.impl.DefaultBearerTokenResolver;
import com.elitescloud.cloudt.authorization.api.client.token.BearerTokenAuthenticationToken;
import lombok.extern.log4j.Log4j2;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * bearerToken 认证过滤器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/2
 */
@Log4j2
public class BearerTokenAuthenticationFilter extends AbstractAuthorizationFilter<BearerTokenAuthenticationToken> {

    private BearerTokenResolver bearerTokenResolver = new DefaultBearerTokenResolver();

    public BearerTokenAuthenticationFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    @Override
    BearerTokenAuthenticationToken obtain(HttpServletRequest request) throws AuthenticationException {
        String token = bearerTokenResolver.resolve(request);
        if (StringUtils.hasText(token)) {
            return new BearerTokenAuthenticationToken(token);
        }

        return null;
    }

    public void setBearerTokenResolver(@NonNull BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }
}
