package com.elitescloud.cloudt.authorization.api.client.config.security.handler;

import cn.hutool.core.util.IdUtil;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.StringUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 默认的认证成功处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/21
 */
public class DefaultAuthenticationSuccessHandler extends AbstractHandler implements AuthenticationSuccessHandler {

    protected final AuthorizationProperties authorizationProperties;
    protected final DelegateAuthenticationCallable authenticationCallable;

    public DefaultAuthenticationSuccessHandler(AuthorizationProperties authorizationProperties, DelegateAuthenticationCallable authenticationCallable) {
        this.authorizationProperties = authorizationProperties;
        this.authenticationCallable = authenticationCallable;
    }

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        // 转换返回结果
        Object result = convertResponseResult(request, authentication);

        // 登录后的回调
        String token = generateToken(request, result, authentication);
        if (authenticationCallable != null && StringUtils.hasText(token)) {
            authenticationCallable.onLogin(request, response, token, authentication);
        }

        // 返回登录结果
        writeResponse(response, ApiResult.ok(result));
    }

    /**
     * 转换返回结果
     *
     * @param request
     * @param authentication
     * @return
     */
    protected Object convertResponseResult(HttpServletRequest request, Authentication authentication) {
        return "登录成功";
    }

    /**
     * 生成token
     * <p>
     * 返回空则不缓存
     *
     * @param request
     * @param responseResult
     * @param authentication
     * @return
     */
    protected String generateToken(HttpServletRequest request, Object responseResult, Authentication authentication) {
        return IdUtil.fastSimpleUUID();
    }
}
