package com.elitescloud.cloudt.authorization.api.client.config.support;

import com.elitescloud.cloudt.security.entity.GeneralUserDetails;

/**
 * 用户认证上下文.
 * <p>
 * 可用于第三方框架时用户信息上下文传递
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/3
 */
public interface AuthenticationContext {

    /**
     * 获取用户ID
     *
     * @return 用户ID
     */
    Long getUserId();

    /**
     * 获取用户名
     *
     * @return 用户名
     */
    String getUsername();

    /**
     * 获取租户ID
     *
     * @return 租户ID
     */
    Long getTenantId();

    /**
     * 获取用户详细信息
     *
     * @return 用户详细信息
     */
    GeneralUserDetails getUser();
}
