package com.elitescloud.cloudt.authorization.api.client.token;

import com.elitescloud.cloudt.authorization.api.client.common.LoginType;
import com.elitescloud.cloudt.common.constant.Terminal;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;

/**
 * 自定义认证方式的身份令牌的父类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/01
 */
public abstract class AbstractCustomAuthenticationToken<T extends AbstractCustomAuthenticationToken<T>> extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -2822502638722492003L;

    /**
     * 登录终端
     */
    private Terminal terminal;

    private Object principal;

    private Object credentials;

    /**
     * 登录类型
     *
     * @return 授权类型
     */
    @NonNull
    public abstract LoginType loginType();

    /**
     * 转换成token对象
     *
     * @param request request
     * @return token
     */
    @NonNull
    public abstract T convert(@NonNull HttpServletRequest request);

    protected AbstractCustomAuthenticationToken(Object principal, Object credentials) {
        super(AuthorityUtils.NO_AUTHORITIES);
        this.principal = principal;
        this.credentials = credentials;

        // 未授权
        super.setAuthenticated(false);
    }

    protected AbstractCustomAuthenticationToken(Object principal, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        this.credentials = credentials;

        // 已授权
        super.setAuthenticated(true);
    }

    @Override
    public void eraseCredentials() {
        super.eraseCredentials();
        this.credentials = null;
    }

    @Override
    public Object getPrincipal() {
        return principal;
    }

    @Override
    public Object getCredentials() {
        return credentials;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    public void setPrincipal(Object principal) {
        this.principal = principal;
    }

    public void setCredentials(Object credentials) {
        this.credentials = credentials;
    }

    public Terminal getTerminal() {
        return terminal;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
