package com.elitescloud.cloudt.authorization.api.client.token;

import com.elitescloud.cloudt.authorization.api.client.principal.AuthorizedClient;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

import java.util.Collection;

/**
 * bearer token令牌.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/2
 */
public class BearerTokenAuthenticationToken extends AbstractAuthenticationToken {

    private final String token;
    private Object principal;
    private AuthorizedClient authorizedClient;

    public BearerTokenAuthenticationToken(String token) {
        super(AuthorityUtils.NO_AUTHORITIES);
        this.token = token;
        super.setAuthenticated(false);
    }

    public BearerTokenAuthenticationToken(String token, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.token = token;
        super.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return token;
    }

    @Override
    public Object getPrincipal() {
        return principal;
    }

    public void setPrincipal(Object principal) {
        this.principal = principal;
    }

    public String getToken() {
        return token;
    }


    public AuthorizedClient getAuthorizedClient() {
        return authorizedClient;
    }

    public void setAuthorizedClient(AuthorizedClient authorizedClient) {
        this.authorizedClient = authorizedClient;
    }
}
