package com.elitescloud.cloudt.authorization.api.client.tool;

import com.elitescloud.cloudt.common.base.BaseCallbackWrapper;
import com.elitescloud.cloudt.common.util.RedisUtils;
import org.springframework.lang.Nullable;

import java.util.concurrent.Callable;
import java.util.function.Function;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/20
 */
public class RedisHelper {

    private final RedisUtils redisUtils;
    private BaseCallbackWrapper callbackWrapper = new DefaultRedisCallbackWrapper();

    public RedisHelper(@Nullable RedisUtils redisUtils, @Nullable BaseCallbackWrapper callbackWrapper) {
        this.redisUtils = redisUtils;

        if (callbackWrapper != null) {
            this.callbackWrapper = callbackWrapper;
        }
    }

    @SuppressWarnings("unchecked")
    public <T> T execute(Function<RedisUtils, T> callable) throws Exception {
        if (redisUtils == null) {
            throw new IllegalStateException("RedisUtil未找到");
        }
        return (T) callbackWrapper.apply(() -> callable.apply(redisUtils), null);
    }

    private static class DefaultRedisCallbackWrapper implements BaseCallbackWrapper {
        @Override
        public Object apply(Callable callable, Object o) throws Exception {
            return callable.call();
        }
    }
}
