package com.elitescloud.cloudt.authorization.api.client.util;

import com.elitescloud.cloudt.authorization.api.client.common.CodeChallengeMethod;
import org.springframework.lang.NonNull;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * pkce工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/23
 */
public class ProofKeyUtil {

    private static final Map<CodeChallengeMethod, MessageDigest> DIGEST_MAP = new HashMap<>();

    private ProofKeyUtil() {
    }

    /**
     * 加密
     *
     * @param codeVerifier 待加密内容
     * @return 加密内容
     */
    @NonNull
    public static String codeChallenge(@NonNull CodeChallengeMethod codeChallengeMethod, @NonNull String codeVerifier) throws Exception {
        MessageDigest digest = DIGEST_MAP.computeIfAbsent(codeChallengeMethod, k -> {
            try {
                return MessageDigest.getInstance("SHA-256");
            } catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        });
        byte[] bytes = digest.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}
