/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.OAuth2ResourceServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.security.SingleClientServletSecurityConfig;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.config.support.RedisAuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.config.support.dubbo.SecurityDubboConfig;
import com.elitescloud.cloudt.authorization.api.client.config.support.springcloud.SecuritySpringCloudConfig;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.elitescloud.cloudt.common.base.BaseCallbackWrapper;
import com.elitescloud.cloudt.common.config.cache.RedisCacheAutoConfiguration;
import com.elitescloud.cloudt.common.util.RedisUtils;
import com.elitescloud.cloudt.context.redis.RedisWrapper;
import com.elitescloud.cloudt.context.threadpool.support.ContextTransfer;
import com.nimbusds.jose.jwk.RSAKey;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.SecurityFilterChain;

@EnableConfigurationProperties(value={AuthorizationProperties.class})
@Import(value={OnEnableSecurity.class, OnDisableSecurity.class})
@AutoConfigureAfter(value={RedisCacheAutoConfiguration.class})
public class AuthorizationClientAutoConfiguration {
    private static final Logger log = LogManager.getLogger(AuthorizationClientAutoConfiguration.class);

    @Bean
    public PasswordEncoder passwordEncoder() {
        DelegatingPasswordEncoder encoder = (DelegatingPasswordEncoder)PasswordEncoderFactories.createDelegatingPasswordEncoder();
        encoder.setDefaultPasswordEncoderForMatches((PasswordEncoder)new BCryptPasswordEncoder());
        return encoder;
    }

    @Bean
    public ContextTransfer<SecurityContext> contextTransferSecurityContext() {
        return new ContextTransfer<SecurityContext>(){

            public SecurityContext getContext() {
                return SecurityContextHolder.getContext();
            }

            public void setContext(SecurityContext context) {
                SecurityContextHolder.setContext((SecurityContext)context);
            }

            public void clearContext() {
                SecurityContextHolder.clearContext();
            }
        };
    }

    @ConditionalOnProperty(prefix="elitesland.authorization", name={"enabled"}, havingValue="false")
    static class OnDisableSecurity {
        public OnDisableSecurity() {
            log.info("\u7981\u7528\u5b89\u5168\u914d\u7f6e");
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultSecurityFilterChain"})
        @Order(value=-2147483648)
        public SecurityFilterChain defaultFilterChain(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).permitAll();
            return (SecurityFilterChain)http.build();
        }
    }

    @ConditionalOnProperty(prefix="elitesland.authorization", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Import(value={SingleClientServletSecurityConfig.class, OAuth2ResourceServletSecurityConfig.class, SecuritySpringCloudConfig.class, SecurityDubboConfig.class})
    static class OnEnableSecurity {
        private final AuthorizationProperties authorizationProperties;

        public OnEnableSecurity(AuthorizationProperties authorizationProperties) {
            this.authorizationProperties = authorizationProperties;
            log.info("\u542f\u7528\u5b89\u5168\u914d\u7f6e");
        }

        @Bean
        @ConditionalOnBean(value={RedisUtils.class})
        @ConditionalOnMissingBean
        public RedisHelper redisHelper(RedisUtils redisUtils, ObjectProvider<RedisWrapper> wrapperObjectProvider) {
            return new RedisHelper(redisUtils, (BaseCallbackWrapper)wrapperObjectProvider.getIfAvailable());
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={RedisHelper.class})
        public AuthenticationCache defaultAuthenticationCache(RedisHelper redisHelper) {
            return new RedisAuthenticationCache(redisHelper);
        }

        @Bean
        @ConditionalOnMissingBean
        public JwtDecoder jwtDecoder(RSAKey rsaKey) {
            JwtDecoder jwtDecoder = JwtUtil.buildJwtDecoder(rsaKey);
            if (jwtDecoder instanceof NimbusJwtDecoder) {
                NimbusJwtDecoder nimbusJwtDecoder = (NimbusJwtDecoder)jwtDecoder;
                if (this.authorizationProperties.getTokenRenewal() != null && this.authorizationProperties.getTokenRenewal().toSeconds() > 0L) {
                    nimbusJwtDecoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(Collections.emptyList()));
                }
            }
            return jwtDecoder;
        }
    }
}

