/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config;

import com.elitescloud.cloudt.authorization.api.client.client.config.OAuthClientProperties;
import com.elitescloud.cloudt.authorization.api.client.common.AuthorizationType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="elitesland.authorization")
public class AuthorizationProperties {
    public static final String CONFIG_PREFIX = "elitesland.authorization";
    private Boolean enabled = true;
    private AuthorizationType type = AuthorizationType.SINGLE;
    private Duration tokenTtl = Duration.ofMinutes(30L);
    private Duration tokenRenewal = Duration.ofMinutes(30L);
    private Duration tokenRenewalRate = Duration.ofMillis(10L);
    private Boolean anonymousEnabled = false;
    private Set<String> allowList = new HashSet<String>(8);
    private Set<String> rejectList = new HashSet<String>(8);
    private Boolean csrfEnabled = false;
    private Boolean corsEnabled = false;
    private List<CorsConfig> cors = new ArrayList<CorsConfig>();
    private final OAuth2Client oauth2Client = new OAuth2Client();
    private final List<OAuth2Client> externalOauth2Clients = new ArrayList<OAuth2Client>();
    @NestedConfigurationProperty
    private final OAuthClientProperties client = new OAuthClientProperties();
    private String rolePrefix = "ROLE_";
    private String loginPage = null;
    private String redirectUriPrefix = null;

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AuthorizationType getType() {
        return this.type;
    }

    public void setType(AuthorizationType type) {
        this.type = type;
    }

    public Duration getTokenTtl() {
        return this.tokenTtl;
    }

    public void setTokenTtl(Duration tokenTtl) {
        this.tokenTtl = tokenTtl;
    }

    public Duration getTokenRenewal() {
        return this.tokenRenewal;
    }

    public void setTokenRenewal(Duration tokenRenewal) {
        this.tokenRenewal = tokenRenewal;
    }

    public Duration getTokenRenewalRate() {
        return this.tokenRenewalRate;
    }

    public void setTokenRenewalRate(Duration tokenRenewalRate) {
        this.tokenRenewalRate = tokenRenewalRate;
    }

    public Boolean getAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    public void setAnonymousEnabled(Boolean anonymousEnabled) {
        this.anonymousEnabled = anonymousEnabled;
    }

    public Set<String> getAllowList() {
        return this.allowList;
    }

    public void setAllowList(Set<String> allowList) {
        this.allowList = allowList;
    }

    public Set<String> getRejectList() {
        return this.rejectList;
    }

    public void setRejectList(Set<String> rejectList) {
        this.rejectList = rejectList;
    }

    public Boolean getCsrfEnabled() {
        return this.csrfEnabled;
    }

    public void setCsrfEnabled(Boolean csrfEnabled) {
        this.csrfEnabled = csrfEnabled;
    }

    public Boolean getCorsEnabled() {
        return this.corsEnabled;
    }

    public void setCorsEnabled(Boolean corsEnabled) {
        this.corsEnabled = corsEnabled;
    }

    public List<CorsConfig> getCors() {
        return this.cors;
    }

    public void setCors(List<CorsConfig> cors) {
        this.cors = cors;
    }

    public OAuth2Client getOauth2Client() {
        return this.oauth2Client;
    }

    public List<OAuth2Client> getExternalOauth2Clients() {
        return this.externalOauth2Clients;
    }

    public OAuthClientProperties getClient() {
        return this.client;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public String getRedirectUriPrefix() {
        return this.redirectUriPrefix;
    }

    public void setRedirectUriPrefix(String redirectUriPrefix) {
        this.redirectUriPrefix = redirectUriPrefix;
    }

    public static class OAuth2Client {
        private String serverAddress;
        private String clientId;
        private String clientSecret;
        private String authorizeEndpoint;
        private String tokenEndpoint;
        private String userinfoEndpoint;
        private String clientName;
        private String clientIcon;

        public String getServerAddress() {
            return this.serverAddress;
        }

        public void setServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public String getAuthorizeEndpoint() {
            return this.authorizeEndpoint;
        }

        public void setAuthorizeEndpoint(String authorizeEndpoint) {
            this.authorizeEndpoint = authorizeEndpoint;
        }

        public String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        public String getUserinfoEndpoint() {
            return this.userinfoEndpoint;
        }

        public void setUserinfoEndpoint(String userinfoEndpoint) {
            this.userinfoEndpoint = userinfoEndpoint;
        }

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public String getClientIcon() {
            return this.clientIcon;
        }

        public void setClientIcon(String clientIcon) {
            this.clientIcon = clientIcon;
        }
    }

    public static class CorsConfig {
        private String pathMatcher = "/**";
        private Set<String> allowedOriginPatterns = new HashSet<String>();
        private Set<String> allowedOrigins = new HashSet<String>();
        private Set<String> allowedHeaders = new HashSet<String>();
        private Set<String> allowedMethods = new HashSet<String>();
        private boolean allowCredentials;

        public String getPathMatcher() {
            return this.pathMatcher;
        }

        public void setPathMatcher(String pathMatcher) {
            this.pathMatcher = pathMatcher;
        }

        public Set<String> getAllowedOriginPatterns() {
            return this.allowedOriginPatterns;
        }

        public void setAllowedOriginPatterns(Set<String> allowedOriginPatterns) {
            this.allowedOriginPatterns = allowedOriginPatterns;
        }

        public Set<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        public void setAllowedOrigins(Set<String> allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public Set<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        public void setAllowedHeaders(Set<String> allowedHeaders) {
            this.allowedHeaders = allowedHeaders;
        }

        public Set<String> getAllowedMethods() {
            return this.allowedMethods;
        }

        public void setAllowedMethods(Set<String> allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public boolean isAllowCredentials() {
            return this.allowCredentials;
        }

        public void setAllowCredentials(boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }
    }
}

