/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security;

import cn.hutool.core.util.BooleanUtil;
import com.elitescloud.cloudt.authorization.api.client.common.InterceptUri;
import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.configurer.DefaultAuthorizationConfigurer;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DefaultAccessDeniedHandler;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DefaultAuthenticationEntryPointHandler;
import com.elitescloud.cloudt.authorization.api.client.config.security.handler.DelegateAuthenticationCallable;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitescloud.cloudt.authorization.sdk.config.security.configurer.SsoFilterConfigurer;
import com.elitescloud.cloudt.authorization.sdk.sso.SsoProvider;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public abstract class AbstractServletSecurityConfig {
    private static final Logger log = LogManager.getLogger(AbstractServletSecurityConfig.class);
    public static final String SECURITY_CHAIN_DEFAULT = "defaultSecurityFilterChain";
    public static final String SECURITY_CHAIN_AUTH2_SERVER = "authorizationServerSecurityFilterChain";
    protected AuthorizationProperties authorizationProperties;
    private AuthorizationSdkProperties authorizationSdkProperties;
    protected ObjectProvider<AuthenticationCache> cacheObjectProvider;
    protected ObjectProvider<AuthenticationCallable> authenticationCallableObjectProvider;
    protected ObjectProvider<SsoProvider> ssoProviderObjectProvider;

    protected AbstractServletSecurityConfig() {
    }

    protected HttpSecurity defaultSecurityConfig(HttpSecurity http) throws Exception {
        if (Boolean.FALSE.equals(this.authorizationProperties.getCsrfEnabled())) {
            http.csrf().disable();
        }
        this.corsConfiguration(http);
        ((HttpSecurity)((SsoFilterConfigurer)((HttpSecurity)((DefaultAuthorizationConfigurer)http.authorizeRequests(this.authorizeRequest()).apply(new DefaultAuthorizationConfigurer(this.authorizationProperties, (AuthenticationCache)this.cacheObjectProvider.getIfAvailable()))).needBearerTokenAuthenticationFilter(this.needCloudtBearerTokenAuthenticationFilter()).and()).apply((SecurityConfigurerAdapter)new SsoFilterConfigurer(this.authorizationSdkProperties))).setSsoProvider((SsoProvider)this.ssoProviderObjectProvider.getIfAvailable()).and()).exceptionHandling(this.exceptionHandlingCustomizer());
        return http;
    }

    protected void corsConfiguration(HttpSecurity http) throws Exception {
        if (Boolean.FALSE.equals(this.authorizationProperties.getCorsEnabled())) {
            http.cors().disable();
            return;
        }
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        for (AuthorizationProperties.CorsConfig cors : this.authorizationProperties.getCors()) {
            CorsConfiguration corsConfiguration = new CorsConfiguration();
            cors.getAllowedOriginPatterns().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedOriginPattern(arg_0));
            cors.getAllowedOrigins().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedOrigin(arg_0));
            cors.getAllowedHeaders().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedHeader(arg_0));
            cors.getAllowedMethods().forEach(arg_0 -> ((CorsConfiguration)corsConfiguration).addAllowedMethod(arg_0));
            corsConfiguration.setAllowCredentials(Boolean.valueOf(cors.isAllowCredentials()));
            source.registerCorsConfiguration(cors.getPathMatcher(), corsConfiguration);
        }
        http.cors(configurer -> configurer.configurationSource((CorsConfigurationSource)source));
    }

    protected Customizer<ExceptionHandlingConfigurer<HttpSecurity>> exceptionHandlingCustomizer() {
        return configurer -> {
            configurer.authenticationEntryPoint((AuthenticationEntryPoint)new DefaultAuthenticationEntryPointHandler(this.authorizationProperties.getLoginPage()));
            configurer.accessDeniedHandler((AccessDeniedHandler)new DefaultAccessDeniedHandler());
        };
    }

    protected Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> authorizeRequest() {
        return urlRegistry -> {
            if (BooleanUtil.isTrue((Boolean)this.authorizationProperties.getAnonymousEnabled())) {
                Set<String> rejectList = this.getRejectUris();
                if (!rejectList.isEmpty()) {
                    urlRegistry.mvcMatchers((String[])rejectList.toArray(String[]::new)).authenticated();
                }
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).permitAll();
                return;
            }
            Set<String> allowList = this.getAllowUris();
            if (!allowList.isEmpty()) {
                urlRegistry.mvcMatchers((String[])allowList.toArray(String[]::new)).permitAll();
            }
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
        };
    }

    protected Customizer<OAuth2ResourceServerConfigurer<HttpSecurity>> oauth2ResourceServer() {
        return OAuth2ResourceServerConfigurer::jwt;
    }

    protected Set<String> getRejectUris() {
        HashSet<String> rejectList = new HashSet<String>();
        rejectList.addAll(InterceptUri.getRejectUri());
        rejectList.addAll(this.authorizationProperties.getRejectList());
        return rejectList;
    }

    protected Set<String> getAllowUris() {
        HashSet<String> allowList = new HashSet<String>();
        allowList.addAll(InterceptUri.getAllowUri());
        allowList.addAll(this.authorizationProperties.getAllowList());
        if (StringUtils.hasText((String)this.authorizationProperties.getLoginPage())) {
            allowList.add(this.authorizationProperties.getLoginPage());
        }
        return allowList;
    }

    protected DelegateAuthenticationCallable getDelegateAuthenticationCallable() {
        return DelegateAuthenticationCallable.getInstance(this.authenticationCallableObjectProvider);
    }

    protected boolean needCloudtBearerTokenAuthenticationFilter() {
        return true;
    }

    @Autowired
    public void setAuthorizationProperties(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    @Autowired
    public void setAuthorizationSdkProperties(AuthorizationSdkProperties authorizationSdkProperties) {
        this.authorizationSdkProperties = authorizationSdkProperties;
    }

    @Autowired
    public void setCacheObjectProvider(ObjectProvider<AuthenticationCache> cacheObjectProvider) {
        this.cacheObjectProvider = cacheObjectProvider;
    }

    @Autowired
    public void setAuthenticationCallableObjectProvider(ObjectProvider<AuthenticationCallable> authenticationCallableObjectProvider) {
        this.authenticationCallableObjectProvider = authenticationCallableObjectProvider;
    }

    @Autowired
    public void setSsoProviderObjectProvider(ObjectProvider<SsoProvider> ssoProviderObjectProvider) {
        this.ssoProviderObjectProvider = ssoProviderObjectProvider;
    }
}

