/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security.configurer.filter;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.api.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.cloudt.authorization.api.client.config.security.resolver.impl.DefaultBearerTokenResolver;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class AccessTokenRenewalFilter
extends OncePerRequestFilter {
    private static final Logger log = LogManager.getLogger(AccessTokenRenewalFilter.class);
    private final AuthorizationProperties authorizationProperties;
    private final AuthenticationCache authenticationCache;
    private BearerTokenResolver bearerTokenResolver = new DefaultBearerTokenResolver();
    private Cache<String, String> tokenRefreshCache = null;

    public AccessTokenRenewalFilter(AuthorizationProperties authorizationProperties, AuthenticationCache authenticationCache) {
        this.authorizationProperties = authorizationProperties;
        this.authenticationCache = authenticationCache;
        this.tokenRefreshCache = Caffeine.newBuilder().expireAfterWrite(authorizationProperties.getTokenRenewalRate()).maximumSize(5000L).build();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token;
        if (this.renewal() && StringUtils.hasText((String)(token = this.bearerTokenResolver.resolve(request)))) {
            this.refreshTokenTtl(token);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void refreshTokenTtl(String token) {
        String principal = (String)this.tokenRefreshCache.getIfPresent((Object)token);
        if (principal == null) {
            CompletableFuture.runAsync(() -> {
                GeneralUserDetails user = this.authenticationCache.getUserDetail(token);
                if (user == null) {
                    return;
                }
                this.authenticationCache.setUserDetail(token, user, this.authorizationProperties.getTokenRenewal());
                this.tokenRefreshCache.put((Object)token, (Object)"true");
            });
        }
    }

    private boolean renewal() {
        return this.authorizationProperties.getTokenRenewal() != null && this.authorizationProperties.getTokenRenewal().getSeconds() > 0L;
    }

    public void setBearerTokenResolver(@NonNull BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }
}

