/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security.configurer.filter;

import com.elitescloud.cloudt.authorization.api.client.config.security.configurer.filter.AbstractAuthorizationFilter;
import com.elitescloud.cloudt.authorization.api.client.config.security.resolver.BearerTokenResolver;
import com.elitescloud.cloudt.authorization.api.client.config.security.resolver.impl.DefaultBearerTokenResolver;
import com.elitescloud.cloudt.authorization.api.client.token.BearerTokenAuthenticationToken;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.StringUtils;

public class BearerTokenAuthenticationFilter
extends AbstractAuthorizationFilter<BearerTokenAuthenticationToken> {
    private static final Logger log = LogManager.getLogger(BearerTokenAuthenticationFilter.class);
    private BearerTokenResolver bearerTokenResolver = new DefaultBearerTokenResolver();

    public BearerTokenAuthenticationFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    @Override
    BearerTokenAuthenticationToken obtain(HttpServletRequest request) throws AuthenticationException {
        String token = this.bearerTokenResolver.resolve(request);
        if (StringUtils.hasText((String)token)) {
            return new BearerTokenAuthenticationToken(token);
        }
        return null;
    }

    public void setBearerTokenResolver(@NonNull BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }
}

