/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security.handler;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.context.SpringContextHolder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractHandler {
    private static final Logger log = LogManager.getLogger(AbstractHandler.class);
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private ObjectMapper objectMapper;

    protected void writeResponse(@NonNull HttpServletResponse response, @NonNull Object result) throws IOException {
        this.writeResponse(response, result, HttpStatus.OK);
    }

    protected void writeResponse(@NonNull HttpServletResponse response, @NonNull Object result, HttpStatus httpStatus) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType("application/json");
        response.setStatus(httpStatus == null ? HttpStatus.OK.value() : httpStatus.value());
        String content = null;
        try {
            content = result instanceof String ? (String)result : this.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            log.error("\u8fd4\u56deresponse\u5f02\u5e38\uff1a", (Throwable)e);
            content = ((Throwable)ObjectUtil.defaultIfNull((Object)e.getCause(), (Object)((Object)e))).getMessage();
        }
        try (PrintWriter writer = response.getWriter();){
            writer.write(content);
        }
        catch (IOException e) {
            log.error("\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a", (Throwable)e);
            throw e;
        }
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        this.redirectStrategy.sendRedirect(request, response, url);
    }

    protected void sendRedirect(String uriPrefix, DefaultSavedRequest savedRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!StringUtils.hasText((String)uriPrefix)) {
            this.sendRedirect(request, response, savedRequest.getRedirectUrl());
            return;
        }
        if (uriPrefix.endsWith("/")) {
            uriPrefix = uriPrefix.substring(0, uriPrefix.length() - 1);
        }
        String queryString = StringUtils.hasText((String)savedRequest.getQueryString()) ? "?" + savedRequest.getQueryString() : "";
        String url = uriPrefix + savedRequest.getRequestURI() + queryString;
        this.sendRedirect(request, response, url);
    }

    protected boolean supportRedirect(HttpServletRequest request) {
        String redirect = request.getHeader("X-Auth-Redirect");
        return redirect == null || "true".equalsIgnoreCase(redirect);
    }

    protected boolean supportRedirect(SavedRequest request) {
        List redirect = request.getHeaderValues("X-Auth-Redirect");
        if (CollectionUtils.isEmpty((Collection)redirect)) {
            return true;
        }
        for (String s : redirect) {
            if (!"true".equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = (ObjectMapper)SpringContextHolder.getBean(ObjectMapper.class);
        }
        return this.objectMapper;
    }
}

