/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security.handler;

import com.elitescloud.cloudt.authorization.api.client.config.security.handler.AbstractHandler;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.StringUtils;

public class DefaultAuthenticationEntryPointHandler
extends AbstractHandler
implements AuthenticationEntryPoint {
    private static final Logger log = LogManager.getLogger(DefaultAuthenticationEntryPointHandler.class);
    private final String loginPage;

    public DefaultAuthenticationEntryPointHandler(String loginPage) {
        this.loginPage = loginPage;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        log.info(request.getRequestURI() + "\u672a\u8ba4\u8bc1\uff1a", (Throwable)authException);
        if (StringUtils.hasText((String)this.loginPage) && this.supportRedirect(request)) {
            this.sendRedirect(request, response, this.loginPage);
            return;
        }
        ApiResult result = ApiResult.fail((ApiCode)ApiCode.UNAUTHORIZED);
        this.writeResponse(response, result, HttpStatus.UNAUTHORIZED);
    }
}

