/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security.handler;

import com.elitescloud.cloudt.authorization.api.client.config.security.handler.AbstractHandler;
import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class DefaultAuthenticationFailureHandler
extends AbstractHandler
implements AuthenticationFailureHandler {
    private static final Logger log = LogManager.getLogger(DefaultAuthenticationFailureHandler.class);
    private final AuthenticationCallable authenticationCallable;

    public DefaultAuthenticationFailureHandler(AuthenticationCallable authenticationCallable) {
        this.authenticationCallable = authenticationCallable;
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String errorMessage = exception.getMessage();
        if (exception instanceof InvalidBearerTokenException) {
            errorMessage = "\u8eab\u4efd\u8ba4\u8bc1\u65e0\u6548\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
        } else {
            log.error("\u8ba4\u8bc1\u5931\u8d25\uff1a", (Throwable)exception);
        }
        ApiResult result = ApiResult.result((ApiCode)ApiCode.AUTHENTICATION_EXCEPTION, (String)errorMessage, null);
        this.writeResponse(response, result);
        request.setAttribute("cloudtLoginResult", (Object)result);
        if (this.authenticationCallable != null) {
            this.authenticationCallable.onLoginFailure(request, response, exception);
        }
    }
}

