/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.security.handler;

import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCallable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.CollectionUtils;

public class DelegateAuthenticationCallable
implements AuthenticationCallable {
    private final List<AuthenticationCallable> authenticationCallables;

    public DelegateAuthenticationCallable(List<AuthenticationCallable> authenticationCallables) {
        this.authenticationCallables = authenticationCallables;
    }

    public static DelegateAuthenticationCallable getInstance(ObjectProvider<AuthenticationCallable> objectProvider) {
        return new DelegateAuthenticationCallable(objectProvider.stream().collect(Collectors.toList()));
    }

    @Override
    public void onLogin(HttpServletRequest request, HttpServletResponse response, String token, Authentication authentication) throws IOException, ServletException {
        if (CollectionUtils.isEmpty(this.authenticationCallables)) {
            return;
        }
        for (AuthenticationCallable authenticationCallable : this.authenticationCallables) {
            authenticationCallable.onLogin(request, response, token, authentication);
        }
    }

    @Override
    public void onLoginFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        if (CollectionUtils.isEmpty(this.authenticationCallables)) {
            return;
        }
        for (AuthenticationCallable authenticationCallable : this.authenticationCallables) {
            authenticationCallable.onLoginFailure(request, response, exception);
        }
    }

    @Override
    public void onLogout(HttpServletRequest request, HttpServletResponse response, String token, Object principal) {
        if (CollectionUtils.isEmpty(this.authenticationCallables)) {
            return;
        }
        for (AuthenticationCallable authenticationCallable : this.authenticationCallables) {
            authenticationCallable.onLogout(request, response, token, principal);
        }
    }
}

