/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.support;

import com.elitescloud.cloudt.authorization.api.client.config.support.AuthenticationCache;
import com.elitescloud.cloudt.authorization.api.client.tool.RedisHelper;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.NonNull;

public class RedisAuthenticationCache
implements AuthenticationCache {
    private static final Logger log = LogManager.getLogger(RedisAuthenticationCache.class);
    private final RedisHelper redisHelper;

    public RedisAuthenticationCache(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    @Override
    public void setUserDetail(@NonNull String key, @NonNull GeneralUserDetails user, Duration timeToLive) {
        try {
            this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateCacheKey(key);
                if (timeToLive != null) {
                    redisUtils.set(cacheKey, (Object)user, timeToLive.toSeconds());
                    return null;
                }
                redisUtils.set(cacheKey, (Object)user);
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u7f13\u5b58\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public GeneralUserDetails getUserDetail(@NonNull String key) {
        try {
            return this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateCacheKey(key);
                return (GeneralUserDetails)redisUtils.get(cacheKey);
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void removeUserDetail(String key) {
        try {
            this.redisHelper.execute(redisUtils -> {
                String cacheKey = this.generateCacheKey(key);
                redisUtils.del(new String[]{cacheKey});
                return null;
            });
        }
        catch (Exception e) {
            throw new BusinessException("\u5220\u9664\u7528\u6237\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private String generateCacheKey(String cacheKey) {
        return "cloudt:current_user:" + cacheKey;
    }
}

