/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.config.support.springcloud;

import com.elitescloud.cloudt.authorization.api.client.util.JwtUtil;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyStore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.BootstrapConfiguration;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;

@Import(value={AuthorizationOnSpringCloudConfig.class, AuthorizationOnNoSpringCloudConfig.class})
public class SecuritySpringCloudConfig {

    @ConditionalOnMissingClass(value={"org.springframework.cloud.bootstrap.BootstrapConfiguration"})
    @EnableConfigurationProperties(value={CustomKeyProperties.class})
    static class AuthorizationOnNoSpringCloudConfig {
        AuthorizationOnNoSpringCloudConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RSAKey rsaKeySource(CustomKeyProperties keyProperties) {
            CustomKeyProperties.KeyStore keyStoreSpring = keyProperties.getKeyStore();
            KeyStore keyStore = JwtUtil.loadKeystore(keyStoreSpring.getLocation(), keyStoreSpring.getType(), keyStoreSpring.getPassword(), keyStoreSpring.getAlias(), keyStoreSpring.getSecret());
            return JwtUtil.loadRSAKey(keyStore, keyStoreSpring.getAlias(), keyStoreSpring.getSecret());
        }

        @ConfigurationProperties(value="encrypt")
        static class CustomKeyProperties {
            private static final String PREFIX = "encrypt";
            private String key;
            private String salt = "deadbeef";
            private boolean failOnError = true;
            private KeyStore keyStore = new KeyStore();

            CustomKeyProperties() {
            }

            public boolean isFailOnError() {
                return this.failOnError;
            }

            public void setFailOnError(boolean failOnError) {
                this.failOnError = failOnError;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getSalt() {
                return this.salt;
            }

            public void setSalt(String salt) {
                this.salt = salt;
            }

            public KeyStore getKeyStore() {
                return this.keyStore;
            }

            public void setKeyStore(KeyStore keyStore) {
                this.keyStore = keyStore;
            }

            public static class KeyStore {
                private Resource location;
                private String password;
                private String alias;
                private String secret;
                private String type = "jks";

                public String getAlias() {
                    return this.alias;
                }

                public void setAlias(String alias) {
                    this.alias = alias;
                }

                public Resource getLocation() {
                    return this.location;
                }

                public void setLocation(Resource location) {
                    this.location = location;
                }

                public String getPassword() {
                    return this.password;
                }

                public String getType() {
                    return this.type;
                }

                public void setPassword(String password) {
                    this.password = password;
                }

                public String getSecret() {
                    return this.secret == null ? this.password : this.secret;
                }

                public void setSecret(String secret) {
                    this.secret = secret;
                }

                public void setType(String type) {
                    this.type = type;
                }
            }
        }
    }

    @ConditionalOnClass(value={BootstrapConfiguration.class})
    static class AuthorizationOnSpringCloudConfig {
        AuthorizationOnSpringCloudConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RSAKey rsaKeySource(KeyProperties keyProperties) {
            KeyProperties.KeyStore keyStoreSpring = keyProperties.getKeyStore();
            KeyStore keyStore = JwtUtil.loadKeystore(keyStoreSpring.getLocation(), keyStoreSpring.getType(), keyStoreSpring.getPassword(), keyStoreSpring.getAlias(), keyStoreSpring.getSecret());
            return JwtUtil.loadRSAKey(keyStore, keyStoreSpring.getAlias(), keyStoreSpring.getSecret());
        }
    }
}

