/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.principal;

import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.CollectionUtils;

public class AuthorizedClient
implements Serializable {
    private static final long serialVersionUID = -2450603428618865616L;
    private String clientId;
    private List<String> scopes;

    public static AuthorizedClient buildByJwt(Jwt jwt) {
        AuthorizedClient authorizedClient = new AuthorizedClient();
        List audience = jwt.getAudience();
        if (!CollectionUtils.isEmpty((Collection)audience)) {
            authorizedClient.setClientId((String)audience.get(0));
        }
        List scopes = jwt.getClaimAsStringList("scope");
        authorizedClient.setScopes((List)ObjectUtil.defaultIfNull((Object)scopes, Collections.emptyList()));
        return authorizedClient;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizedClient)) {
            return false;
        }
        AuthorizedClient other = (AuthorizedClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        List<String> this$scopes = this.getScopes();
        List<String> other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthorizedClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        List<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        return result;
    }

    public String toString() {
        return "AuthorizedClient(clientId=" + this.getClientId() + ", scopes=" + this.getScopes() + ")";
    }
}

