/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.authorization.api.client.tool;

import com.elitescloud.cloudt.common.base.BaseCallbackWrapper;
import com.elitescloud.cloudt.common.util.RedisUtils;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.springframework.lang.Nullable;

public class RedisHelper {
    private final RedisUtils redisUtils;
    private BaseCallbackWrapper callbackWrapper = new DefaultRedisCallbackWrapper();

    public RedisHelper(@Nullable RedisUtils redisUtils, @Nullable BaseCallbackWrapper callbackWrapper) {
        this.redisUtils = redisUtils;
        if (callbackWrapper != null) {
            this.callbackWrapper = callbackWrapper;
        }
    }

    public <T> T execute(Function<RedisUtils, T> callable) throws Exception {
        if (this.redisUtils == null) {
            throw new IllegalStateException("RedisUtil\u672a\u627e\u5230");
        }
        return (T)this.callbackWrapper.apply(() -> callable.apply(this.redisUtils), null);
    }

    private static class DefaultRedisCallbackWrapper
    implements BaseCallbackWrapper {
        private DefaultRedisCallbackWrapper() {
        }

        public Object apply(Callable callable, Object o) throws Exception {
            return callable.call();
        }
    }
}

