package com.elitescloud.cloudt.authorization.sdk.cas.config;

import com.elitescloud.cloudt.authorization.sdk.config.CloudtOAuth2Client;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.io.Serializable;
import java.time.Duration;

/**
 * CAS客户端.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/3
 */
public class CasClientProperties implements Serializable {
    private static final long serialVersionUID = -3709055985972852554L;

    /**
     * 是否启用
     */
    private Boolean enabled = false;

    /**
     * 平台编码
     */
    private String platformCode;

    /**
     * OAuth2客户端信息
     */
    @NestedConfigurationProperty
    private final CloudtOAuth2Client oauth2Client = new CloudtOAuth2Client();

    /**
     * 是否在同步信息失败时抛出异常
     * 默认false，不影响原主流程，业务可使用该字段
     */
    private Boolean syncFailThrow = false;

    /**
     * 出现异常，是否回滚所有
     * 出现异常时，批量处理的对象是否都回滚
     */
    private Boolean rollBackAllOnException = false;

    /**
     * 自动同步间隔
     */
    private Duration syncInterval = Duration.ofMinutes(30);

    /**
     * 客户端token刷新间隔
     */
    private Duration clientTokenInterval = Duration.ofMinutes(30);

    /**
     * 每次同步用户量
     */
    private Integer syncSize = 50;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public CloudtOAuth2Client getOauth2Client() {
        return oauth2Client;
    }

    public Boolean getSyncFailThrow() {
        return syncFailThrow;
    }

    public void setSyncFailThrow(Boolean syncFailThrow) {
        this.syncFailThrow = syncFailThrow;
    }

    public Boolean getRollBackAllOnException() {
        return rollBackAllOnException;
    }

    public void setRollBackAllOnException(Boolean rollBackAllOnException) {
        this.rollBackAllOnException = rollBackAllOnException;
    }

    public Duration getSyncInterval() {
        return syncInterval;
    }

    public void setSyncInterval(Duration syncInterval) {
        this.syncInterval = syncInterval;
    }

    public Duration getClientTokenInterval() {
        return clientTokenInterval;
    }

    public void setClientTokenInterval(Duration clientTokenInterval) {
        this.clientTokenInterval = clientTokenInterval;
    }

    public Integer getSyncSize() {
        return syncSize;
    }

    public void setSyncSize(Integer syncSize) {
        this.syncSize = syncSize;
    }
}
