package com.elitescloud.cloudt.authorization.sdk.resolver.impl;

import com.elitescloud.cloudt.authorization.sdk.resolver.UniqueRequestResolver;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseCookie;
import org.springframework.util.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.Random;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/26
 */
public class DefaultUniquestResolver implements UniqueRequestResolver {
    private final String seqName;

    private String cookiePath = "/";
    /**
     * 是否现在只有请求时才可以获取，true时js将无法获取
     */
    private boolean cookieHttpOnly = true;
    /**
     * true时只有https才能获取
     */
    private boolean cookieSecure = false;
    /**
     * cookie有效时间，单位秒，-1标识用不失效
     */
    private int cookieMaxAge = (int) Duration.ofMinutes(30).toSeconds();

    public DefaultUniquestResolver(String seqName) {
        this.seqName = seqName;
    }

    @Override
    public String signRequest(HttpServletResponse response) {
        String seqId = generateSeqId();

        // 设置请求头
        response.setHeader(seqName, seqId);

        // 设置cookie
        Cookie cookie = new Cookie(seqName, seqId);
        cookie.setPath(cookiePath);
        cookie.setHttpOnly(cookieHttpOnly);
        cookie.setSecure(cookieSecure);
        cookie.setMaxAge(cookieMaxAge);
        response.addCookie(cookie);

        return seqId;
    }

    @Override
    public String analyze(HttpServletRequest request) {
        String reqId = request.getHeader(seqName);
        if (StringUtils.hasText(reqId)) {
            return reqId;
        }

        var cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (seqName.equalsIgnoreCase(cookie.getName())) {
                    return cookie.getValue();
                }
            }
        }

        return null;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieSecure(boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    private String generateSeqId() {
        String state = System.nanoTime() + "";
        Random random = new Random();
        StringBuilder stateBuilder = new StringBuilder(state);
        for (int i = 0; i < 8; i++) {
            stateBuilder.append(random.nextInt(10));
        }
        return stateBuilder.toString();
    }
}
