package com.elitescloud.cloudt.common.base;

import javax.annotation.Nullable;
import java.io.Serializable;
import java.util.Date;

/**
 * 结果基础类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/9
 */
public abstract class BaseResult<T, R extends BaseResult<T, R>> implements Serializable {
    private static final long serialVersionUID = -3485071992741369563L;
    
    /**
     * 响应码
     */
    private int code;

    /**
     * 响应消息
     */
    private String msg;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 错误号
     */
    @Nullable
    private String errorNo;

    /**
     * 响应数据
     */
    @Nullable
    private T data;

    /**
     * 响应时间
     */
    private Date time;

    public int getCode() {
        return code;
    }

    public R setCode(int code) {
        this.code = code;
        return getSelf();
    }

    public R code(int code) {
        return setCode(code);
    }

    public String getMsg() {
        return msg;
    }

    public R setMsg(String msg) {
        this.msg = msg;
        return getSelf();
    }

    public R msg(String msg) {
        return setMsg(msg);
    }

    public boolean isSuccess() {
        return success;
    }

    public R setSuccess(boolean success) {
        this.success = success;
        return getSelf();
    }

    public R success(boolean success) {
        return setSuccess(success);
    }

    @Nullable
    public String getErrorNo() {
        return errorNo;
    }

    public R setErrorNo(@Nullable String errorNo) {
        this.errorNo = errorNo;
        return getSelf();
    }

    public R errorNo(@Nullable String errorNo) {
        return setErrorNo(errorNo);
    }

    @Nullable
    public T getData() {
        return data;
    }

    public R setData(@Nullable T data) {
        this.data = data;
        return getSelf();
    }

    public R data(@Nullable T data) {
        return setData(data);
    }

    public Date getTime() {
        return time;
    }

    public R setTime(Date time) {
        this.time = time;
        return getSelf();
    }

    public R time(Date time) {
        return setTime(time);
    }

    private R getSelf() {
        return (R) this;
    }

    @Override
    public String toString() {
        return "BaseResult{" +
                "code=" + code +
                ", msg='" + msg + '\'' +
                ", success=" + success +
                ", errorNo='" + errorNo + '\'' +
                ", data=" + data +
                ", time=" + time +
                '}';
    }
}
