package com.elitescloud.cloudt.common.base.param;

import io.swagger.annotations.ApiModelProperty;

import java.util.Collections;
import java.util.List;

/**
 * 带排序的查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/9
 */
public class OrderQueryParam extends QueryParam {
    private static final long serialVersionUID = -3565628852128338713L;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private List<OrderItem> orders;

    public List<OrderItem> getOrders() {
        return orders;
    }

    public void setOrders(List<OrderItem> orders) {
        this.orders = orders;
    }

    public void defaultOrder(OrderItem orderItem) {
        this.defaultOrders(Collections.singletonList(orderItem));
    }

    public void defaultOrders(List<OrderItem> orderItems) {
        if (orderItems == null || orderItems.isEmpty()) {
            return;
        }
        this.orders = orderItems;
    }
}
