package com.elitescloud.cloudt.common.annotation.context.spi;

import java.lang.annotation.*;

/**
 * SPI 接口的注解.
 * <p>
 * 用于扩展SPI接口的功能，按需使用
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/17
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Spi {

    /**
     * 默认实现类
     *
     * @return 类的全量名称
     */
    String[] primary();

    /**
     * 默认实现类
     *
     * @return 默认实现类
     */
    Class<?>[] primaryClass();
}
