/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import com.elitescloud.boot.common.OpenApiException;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RestTemplateHelper.class);
    private final RestTemplate restTemplate;

    private RestTemplateHelper(RestTemplate restTemplate) {
        Assert.notNull((Object)restTemplate, (String)"restTemplate\u4e3a\u7a7a");
        this.restTemplate = restTemplate;
    }

    public static RestTemplateHelper instance(@NotNull RestTemplate restTemplate) {
        return new RestTemplateHelper(restTemplate);
    }

    public <T> T exchange(@NotBlank String url, @NotNull HttpMethod httpMethod, HttpEntity<?> httpEntity, ParameterizedTypeReference<T> responseType, Object ... uriParameters) {
        ResponseEntity response = null;
        try {
            response = this.restTemplate.exchange(url, httpMethod, httpEntity, responseType, uriParameters);
        }
        catch (RestClientException e) {
            LOG.error(url + "\u8c03\u7528\u5931\u8d25\uff1a", (Throwable)e);
            throw new RuntimeException("\u8fdc\u7a0b\u670d\u52a1\u5668\u5f02\u5e38", e);
        }
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff1a{}, {}", (Object)url, (Object)response);
            throw new OpenApiException("\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3\u5931\u8d25", response.getStatusCodeValue());
        }
        LOG.info("\u63a5\u53e3{}\u8c03\u7528\u6210\u529f", (Object)url);
        return (T)response.getBody();
    }
}

