package com.elitescloud.boot;

import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.lang.NonNull;

/**
 * Spring的上下文自动化配置类.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/30
 */
class CloudtSpringContextListener implements SmartApplicationListener {

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationStartingEvent.class);
    }

    @Override
    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (event instanceof ApplicationStartingEvent) {
            CloudtSpringContextHolder.setSpringApplication(((ApplicationStartingEvent) event).getSpringApplication());
        }
    }
}
