package com.elitescloud.boot.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * ObjectMapper.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/15
 */
public class ObjectMapperFactory {
    private static ObjectMapper INSTANCE = null;

    private ObjectMapperFactory() {
    }

    /**
     * ObjectMapper实例
     *
     * @return objectMapper
     */
    public static ObjectMapper instance() {
        if (INSTANCE == null) {
            synchronized (ObjectMapperFactory.class) {
                if (INSTANCE != null) {
                    return INSTANCE;
                }
                INSTANCE = builderInstance()
                        .build();
            }
        }
        return INSTANCE;
    }

    /**
     * 构建者实例
     *
     * @return 构建者实例
     */
    public static Jackson2ObjectMapperBuilder builderInstance() {
        return ObjectMapperFactory.builderInstance(Jackson2ObjectMapperBuilder.json());
    }

    /**
     * 构建者实例
     *
     * @param builder 已有实例
     * @return 构建者实例
     */
    public static Jackson2ObjectMapperBuilder builderInstance(Jackson2ObjectMapperBuilder builder) {
        return builder
                .serializerByType(LocalDateTime.class, new LocalDateTimeSerializer(DatetimeUtil.FORMATTER_DATETIME))
                .serializerByType(LocalDate.class, new LocalDateSerializer(DatetimeUtil.FORMATTER_DATE))
                .deserializerByType(LocalDateTime.class, new LocalDateTimeDeserializer(DatetimeUtil.FORMATTER_DATETIME))
                .deserializerByType(LocalDate.class, new LocalDateDeserializer(DatetimeUtil.FORMATTER_DATE))
                .simpleDateFormat(DatetimeUtil.FORMATTER_DATETIME_STR)
                .serializerByType(Long.class, ToStringSerializer.instance)
                .serializerByType(Long.TYPE, ToStringSerializer.instance)
                .failOnUnknownProperties(false)
                .failOnEmptyBeans(false);
    }
}
