package com.elitescloud.cloudt.common.base.param;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.LinkedHashSet;

/**
 * 查询参数
 *
 * @author Michael Li
 * @date 2018-11-08
 */
public abstract class QueryParam implements Serializable {
    private static final long serialVersionUID = -3263921252635611410L;

    private static final int DEFAULT_PAGE_INDEX = 1;
    private static final int DEFAULT_PAGE_SIZE = 10;

    /**
     * 页码，默认为1
     */
    @ApiModelProperty(value = "页码", example = "1")
    public Integer current = DEFAULT_PAGE_INDEX;

    /**
     * 页大小，默认为10
     */
    @ApiModelProperty(value = "页大小", example = "10")
    public Integer size = DEFAULT_PAGE_SIZE;

    /**
     * 搜索关键字
     */
    @ApiModelProperty(value = "搜索内容")
    private String keyword;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    private LinkedHashSet<Long> idSet;

    public Integer getCurrent() {
        return current > 0 ? current - 1 : 0;
    }

    public Integer getSize() {
        return size;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public LinkedHashSet<Long> getIdSet() {
        return idSet;
    }

    public void setIdSet(LinkedHashSet<Long> idSet) {
        this.idSet = idSet;
    }

    public void setCurrent(Integer current) {
        if (current == null || current < 0) {
            this.current = DEFAULT_PAGE_INDEX;
        } else {
            this.current = current;
        }
    }

    public void setSize(Integer size) {
        if (size == null || size <= 0) {
            this.size = DEFAULT_PAGE_SIZE;
        } else {
            this.size = size;
        }
    }

}
