/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.util.StringUtils;

public class DatetimeUtil {
    public static final String FORMATTER_DATETIME_STR = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter FORMATTER_DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String FORMATTER_DATE_STR = "yyyy-MM-dd";
    public static final DateTimeFormatter FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String FORMATTER_TIME_STR = "HH:mm:ss";
    public static final DateTimeFormatter FORMATTER_TIME = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final String FORMATTER_DATETIME_LONG_STR = "yyyyMMddHHmmssSSS";
    public static final DateTimeFormatter FORMATTER_DATETIME_LONG = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    public static final SimpleDateFormat FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat FORMAT_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final ZoneOffset SYS_ZONE_OFFSET = ZoneOffset.of("+8");
    public static final TimeZone SYS_TIME_ZONE = TimeZone.getTimeZone(SYS_ZONE_OFFSET);

    protected DatetimeUtil() {
    }

    public static String currentTimeStr() {
        return FORMATTER_DATETIME.format(LocalDateTime.now());
    }

    public static String currentTimeLong() {
        return FORMATTER_DATETIME_LONG.format(LocalDateTime.now());
    }

    public static String toStr(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return FORMATTER_DATETIME.format(dateTime);
    }

    public static String toStr(LocalDate date) {
        if (date == null) {
            return null;
        }
        return FORMATTER_DATE.format(date);
    }

    public static String toStr(LocalTime time) {
        if (time == null) {
            return null;
        }
        return FORMATTER_TIME.format(time);
    }

    public static String toStr(Date time) {
        if (time == null) {
            return null;
        }
        return FORMAT_DATETIME.format(time);
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atOffset(SYS_ZONE_OFFSET).toLocalDateTime();
    }

    public static Date localDateTime2Date(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return Date.from(dateTime.atZone(SYS_ZONE_OFFSET).toInstant());
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        if (instant == null) {
            return null;
        }
        return instant.atZone(SYS_ZONE_OFFSET).toLocalDateTime();
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.toInstant(SYS_ZONE_OFFSET);
    }

    public static LocalDate parseLocalDate(String date) {
        if (DatetimeUtil.isBlank(date)) {
            return null;
        }
        return LocalDate.parse(date, FORMATTER_DATE);
    }

    public static LocalDateTime parseLocalDateTime(String datetime) {
        if (DatetimeUtil.isBlank(datetime)) {
            return null;
        }
        return LocalDateTime.parse(datetime, FORMATTER_DATETIME);
    }

    public static LocalTime parseLocalTime(String localTime) {
        if (DatetimeUtil.isBlank(localTime)) {
            return null;
        }
        return LocalTime.parse(localTime, FORMATTER_TIME);
    }

    public static Date parseForDate(String date) {
        try {
            return FORMAT_DATE.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    public static Date parseForDatetime(String date) {
        if (DatetimeUtil.isBlank(date)) {
            return null;
        }
        try {
            return FORMAT_DATETIME.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }

    public static int getWeekOfWeekBasedYear(LocalDate date) {
        return date.get(WeekFields.ISO.weekOfWeekBasedYear());
    }

    public static LocalDateTime min(LocalDateTime time1, LocalDateTime time2) {
        if (time1 == null) {
            return time2;
        }
        if (time2 == null) {
            return time1;
        }
        return time1.isBefore(time2) ? time1 : time2;
    }

    public static LocalDate min(LocalDate time1, LocalDate time2) {
        if (time1 == null) {
            return time2;
        }
        if (time2 == null) {
            return time1;
        }
        return time1.isBefore(time2) ? time1 : time2;
    }

    private static boolean isBlank(String str) {
        return !StringUtils.hasText((String)str);
    }
}

