/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.common.base;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;

public class PagingVO<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -4792752946712260031L;
    @ApiModelProperty(value="\u603b\u8bb0\u5f55\u6570")
    private long total;
    @ApiModelProperty(value="\u6c47\u603b\u6570\u636e")
    private Map<String, Object> aggregatedData;
    @ApiModelProperty(value="\u6570\u636e\u5217\u8868")
    private List<T> records;

    public PagingVO() {
        this(0L, null);
    }

    public PagingVO(long total, List<T> records) {
        this.total = total;
        this.records = records == null ? Collections.emptyList() : records;
    }

    public PagingVO(long total, List<T> records, Map<String, Object> aggregatedData) {
        this.total = total;
        this.records = records == null ? Collections.emptyList() : records;
        this.aggregatedData = records == null ? Collections.emptyMap() : aggregatedData;
    }

    public static <T extends Serializable> PagingVO<T> builder() {
        return new PagingVO<T>();
    }

    public Map<String, Object> getAggregatedData() {
        return this.aggregatedData;
    }

    public PagingVO<T> build() {
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public PagingVO<T> setTotal(long total) {
        this.total = total;
        return this;
    }

    public PagingVO<T> total(long total) {
        return this.setTotal(total);
    }

    public List<T> getRecords() {
        return this.records;
    }

    public PagingVO<T> setAggregatedData(Map<String, Object> aggregatedData) {
        this.aggregatedData = aggregatedData;
        return this;
    }

    public PagingVO<T> setRecords(List<T> records) {
        this.records = records;
        return this;
    }

    public PagingVO<T> records(List<T> records) {
        return this.setRecords(records);
    }

    public static <T extends Serializable> PagingVO<T> empty() {
        return new PagingVO<T>();
    }

    public <R extends Serializable> PagingVO<R> map(@NotNull Function<T, R> mapper) {
        if (this.isEmpty()) {
            return new PagingVO<T>();
        }
        List result = this.records.stream().map(mapper).collect(Collectors.toList());
        return new PagingVO(this.total, result);
    }

    public void each(Consumer<T> consumer) {
        if (this.isEmpty()) {
            return;
        }
        for (Serializable record : this.records) {
            consumer.accept(record);
        }
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.records.stream();
    }

    public boolean isEmpty() {
        return this.isEmpty(this.records);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty(this.records);
    }

    public int size() {
        return this.isEmpty() ? 0 : this.records.size();
    }

    public String toString() {
        return "Paging{total=" + this.total + ", records=" + this.records + "}";
    }

    private boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }
}

