/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.support;

import com.elitescloud.boot.CloudtSpringContextHolder;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DiscoveryClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryClientHttpRequestInterceptor.class);
    private final Set<String> serviceNames;
    private DiscoveryClient discoveryClient;

    public DiscoveryClientHttpRequestInterceptor(Set<String> serviceNames) {
        this.serviceNames = serviceNames;
    }

    @NonNull
    public ClientHttpResponse intercept(@NonNull HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
        URI uri = request.getURI();
        Assert.notNull((Object)uri, (String)"Request URI\u4e3a\u7a7a");
        final URI newUri = this.reBuildUri(uri);
        if (newUri == null) {
            LOG.info("request uri is \uff1a{}", (Object)uri);
            return execution.execute(request, body);
        }
        LOG.info("new request uri is: {}", (Object)newUri);
        return execution.execute((HttpRequest)new HttpRequestWrapper(request){

            public URI getURI() {
                return newUri;
            }
        }, body);
    }

    private URI reBuildUri(URI uri) {
        String host = uri.getHost();
        if (!StringUtils.hasText((String)host)) {
            return null;
        }
        if (!CollectionUtils.isEmpty(this.serviceNames)) {
            if (this.serviceNames.contains(host)) {
                return this.reBuildUriByDiscoveryClient(uri, host);
            }
            return null;
        }
        return this.reBuildUriByDiscoveryClient(uri, host);
    }

    private URI reBuildUriByDiscoveryClient(URI uri, String serviceName) {
        List instances = null;
        try {
            instances = this.getDiscoveryClient().getInstances(serviceName);
        }
        catch (Exception e) {
            LOG.warn("\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u83b7\u53d6\u670d\u52a1\u5931\u8d25\uff1a{}", (Object)serviceName, (Object)e);
        }
        if (CollectionUtils.isEmpty((Collection)instances)) {
            LOG.info("\u672a\u53d1\u73b0\u6709\u6548\u670d\u52a1\uff1a{}", (Object)serviceName);
            return null;
        }
        int instanceNum = instances.size();
        ServiceInstance instance = instanceNum == 1 ? (ServiceInstance)instances.get(0) : (ServiceInstance)instances.get(ThreadLocalRandom.current().nextInt(0, instanceNum));
        return LoadBalancerUriTools.reconstructURI((ServiceInstance)new CustomServiceInstance(instance), (URI)uri);
    }

    private DiscoveryClient getDiscoveryClient() {
        if (this.discoveryClient == null) {
            this.discoveryClient = (DiscoveryClient)CloudtSpringContextHolder.getApplicationContext().getBean(DiscoveryClient.class);
        }
        return this.discoveryClient;
    }

    public static class CustomServiceInstance
    implements ServiceInstance {
        private final ServiceInstance instance;

        public CustomServiceInstance(ServiceInstance instance) {
            this.instance = instance;
        }

        public String getServiceId() {
            return this.instance.getServiceId();
        }

        public String getHost() {
            return this.instance.getHost();
        }

        public int getPort() {
            return this.instance.getPort();
        }

        public boolean isSecure() {
            return this.instance.isSecure();
        }

        public URI getUri() {
            return this.instance.getUri();
        }

        public Map<String, String> getMetadata() {
            return this.instance.getMetadata();
        }

        public String getInstanceId() {
            return this.instance.getInstanceId();
        }

        public String getScheme() {
            String scheme = this.instance.getScheme();
            if (StringUtils.hasText((String)scheme)) {
                return scheme;
            }
            return this.instance.getUri().getScheme();
        }
    }
}

