/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import com.elitescloud.boot.support.DiscoveryClientHttpRequestInterceptor;
import com.elitescloud.boot.util.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.validation.constraints.NotBlank;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

public class RestTemplateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RestTemplateFactory.class);
    private static final boolean EXISTS_SPRING_CLOUD = RestTemplateFactory.isPresentClass("org.springframework.cloud.client.discovery.DiscoveryClient", null);

    private RestTemplateFactory() {
    }

    public static RestTemplate instance() {
        return RestTemplateFactory.instance(null);
    }

    public static RestTemplate instance(Function<RestTemplateBuilder, RestTemplateBuilder> restTemplateBuilderFunction) {
        RestTemplateBuilder builder = RestTemplateFactory.initializeBuilder();
        if (restTemplateBuilderFunction != null) {
            builder = restTemplateBuilderFunction.apply(builder);
        }
        return builder.build();
    }

    public static RestTemplate dynamicInstance(Function<RestTemplateBuilder, RestTemplateBuilder> restTemplateBuilderFunction, String ... serviceNames) {
        RestTemplateBuilder builder = RestTemplateFactory.initializeBuilder();
        if (restTemplateBuilderFunction != null) {
            builder = restTemplateBuilderFunction.apply(builder);
        }
        if (EXISTS_SPRING_CLOUD) {
            builder = builder.additionalInterceptors(new ClientHttpRequestInterceptor[]{new DiscoveryClientHttpRequestInterceptor(Arrays.stream(serviceNames).collect(Collectors.toSet()))});
        } else {
            LOG.warn("\u672a\u542f\u7528SpringCloud\uff0c\u65e0\u6cd5\u4ece\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u83b7\u53d6\u670d\u52a1");
        }
        return builder.build();
    }

    private static RestTemplateBuilder initializeBuilder() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(RestTemplateFactory::getClientHttpRequestFactory).uriTemplateHandler(RestTemplateFactory.uriTemplateHandler()).errorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(@NonNull URI url, @NonNull HttpMethod method, @NonNull ClientHttpResponse response) throws IOException {
                LOG.error("RestTemplate\u8bf7\u6c42\u5f02\u5e38\uff1a{}\uff0c{}\uff0c{}", new Object[]{method, url, response.getStatusCode()});
                super.handleError(url, method, response);
            }
        }).customizers(new RestTemplateCustomizer[]{RestTemplateFactory.restTemplateCustomizer()});
    }

    private static UriTemplateHandler uriTemplateHandler() {
        DefaultUriBuilderFactory handler = new DefaultUriBuilderFactory();
        handler.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.TEMPLATE_AND_VALUES);
        return handler;
    }

    private static ClientHttpRequestFactory getClientHttpRequestFactory() {
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy());
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(20);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setSSLSocketFactory(sslConnectionSocketFactory).setConnectionManager((HttpClientConnectionManager)connectionManager).disableAutomaticRetries();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build());
        requestFactory.setConnectTimeout((int)Duration.ofSeconds(10L).toMillis());
        requestFactory.setReadTimeout((int)Duration.ofMinutes(30L).toMillis());
        return requestFactory;
    }

    private static RestTemplateCustomizer restTemplateCustomizer() {
        ObjectMapper objectMapper = ObjectMapperFactory.instance();
        return template -> {
            MappingJackson2HttpMessageConverter jsonConvert = null;
            int xmlConvertIndex = -1;
            int index = 0;
            for (HttpMessageConverter convert : template.getMessageConverters()) {
                if (convert instanceof MappingJackson2XmlHttpMessageConverter) {
                    xmlConvertIndex = index;
                }
                if (convert instanceof MappingJackson2HttpMessageConverter) {
                    jsonConvert = (MappingJackson2HttpMessageConverter)convert;
                }
                ++index;
            }
            if (jsonConvert == null) {
                jsonConvert = new MappingJackson2HttpMessageConverter(objectMapper);
                template.getMessageConverters().add(jsonConvert);
            } else {
                jsonConvert.setObjectMapper(objectMapper);
            }
            if (xmlConvertIndex >= 0) {
                template.getMessageConverters().remove(jsonConvert);
                template.getMessageConverters().add(xmlConvertIndex - 1, jsonConvert);
            }
        };
    }

    private static boolean isPresentClass(@NotBlank String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

