package com.elitescloud.boot.auth.client;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

/**
 * 认证客户端配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/22
 */
@ConfigurationProperties(prefix = CloudtAuthProperties.CONFIG_PREFIX)
public class CloudtAuthProperties {
    public static final String CONFIG_PREFIX = "elitesland.auth.client";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 服务的地址
     */
    private String serverAddr;

    /**
     * 客户端ID
     */
    private String clientId;

    /**
     * 客户端密码
     */
    private String clientSecret;

    /**
     * 客户端刷新token间隔，默认20分钟
     */
    private Duration refreshTokenInterval = Duration.ofMinutes(20);

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getServerAddr() {
        return serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Duration getRefreshTokenInterval() {
        return refreshTokenInterval;
    }

    public void setRefreshTokenInterval(Duration refreshTokenInterval) {
        this.refreshTokenInterval = refreshTokenInterval;
    }
}
