package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.boot.auth.client.common.AuthClientConstant;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;

import java.io.IOException;

/**
 * 客户端认证拦截.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/22
 */
public class ClientAuthorizationInterceptor implements ClientHttpRequestInterceptor {

    @NonNull
    @Override
    public ClientHttpResponse intercept(HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
        if (AuthClientConstant.URI_AUTH_TOKEN.equals(request.getURI().getPath())) {
            // 获取token接口无需放token
            return execution.execute(request, body);
        }
        HttpHeaders headers = request.getHeaders();
        var token = OAuthTokenHolder.getToken();
        if (token == null) {
            throw new IllegalStateException("Token获取失败");
        }

        // 设置token
        headers.add(HttpHeaders.AUTHORIZATION, token.getTokenType() + " " + token.getAccessToken());
        return execution.execute(request, body);
    }
}
