package com.elitescloud.boot.auth.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

/**
 * Token信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/22
 */
public class OAuthToken implements Serializable {

    private static final long serialVersionUID = 7113734801602261824L;
    /**
     * AccessToken
     */
    @JsonProperty("access_token")
    private String accessToken;

    /**
     * 有效期，单位秒
     */
    @JsonProperty("expires_in")
    private Long expiresIn;

    /**
     * token类型
     */
    @JsonProperty("token_type")
    private String tokenType;

    /**
     * 刷新token
     */
    @JsonProperty("refresh_token")
    private String refreshToken;

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public Long getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }
}
