/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.boot.auth.client.CloudtAuthClient;
import com.elitescloud.boot.auth.client.CloudtAuthProperties;
import com.elitescloud.boot.auth.client.config.support.OAuthTokenHolder;
import com.elitescloud.boot.auth.client.config.support.OAuthTokenProvider;
import com.elitescloud.boot.auth.client.model.OAuthToken;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;

public class DefaultOAuthTokenProvider
implements OAuthTokenProvider {
    private final CloudtAuthClient authClient;
    private final CloudtAuthProperties authProperties;
    private OAuthToken authToken;

    public DefaultOAuthTokenProvider(CloudtAuthClient authClient, CloudtAuthProperties authProperties) {
        this.authClient = authClient;
        this.authProperties = authProperties;
    }

    @Override
    public OAuthToken getToken() {
        if (this.authToken == null) {
            this.authToken = this.requestToken();
        }
        return this.authToken;
    }

    @Override
    public OAuthToken refresh() {
        this.authToken = this.requestToken();
        OAuthTokenHolder.setToken(this.authToken);
        return this.authToken;
    }

    private OAuthToken requestToken() {
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"grant_type", (Object)"client_credentials");
        postParam.add((Object)"client_id", (Object)this.authProperties.getClientId());
        postParam.add((Object)"client_secret", (Object)this.authProperties.getClientSecret());
        return this.authClient.exchange("/cloudt/authorization/oauth2/token", HttpMethod.POST, postParam, new ParameterizedTypeReference<OAuthToken>(){}, new Object[0]);
    }
}

