package com.elitescloud.boot.auth.client.config.support;

import com.elitescloud.boot.auth.client.CloudtAuthProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

/**
 * 定时获取token.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/22
 */
public class ObtainTokenTask implements SchedulingConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(ObtainTokenTask.class);

    private final OAuthTokenProvider authTokenProvider;
    private final CloudtAuthProperties authProperties;

    public ObtainTokenTask(OAuthTokenProvider authTokenProvider, CloudtAuthProperties authProperties) {
        this.authTokenProvider = authTokenProvider;
        this.authProperties = authProperties;
    }

    @Override
    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        LOG.info("刷新token间隔：{}min", authProperties.getRefreshTokenInterval().toMinutes());
        taskRegistrar.addFixedDelayTask(this::refreshToken, authProperties.getRefreshTokenInterval().toMillis());
    }

    private void refreshToken() {
        try {
            var token = authTokenProvider.refresh();
            if (token == null) {
                LOG.error("刷新token失败");
                return;
            }
            LOG.info("token刷新成功：{} {}", token.getTokenType(), token.getAccessToken());
        } catch (Throwable e) {
            LOG.error("刷新token异常：", e);
        }
    }


}
