package com.elitescloud.boot.auth.factory.provider;

import com.elitescloud.boot.auth.factory.common.AuthClientProvider;
import com.elitescloud.boot.auth.factory.common.AuthResult;
import com.elitescloud.boot.auth.factory.common.constant.TokenPositionEnum;
import com.elitescloud.boot.auth.factory.provider.properties.BasicAuthProperty;
import com.elitescloud.boot.auth.util.AuthorizationUtil;

import java.io.IOException;
import java.util.Collections;

/**
 * 账户名和密码认证.
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/26 周一
 */
public class BasicAuthClientProvider implements AuthClientProvider<BasicAuthProperty> {

    @Override
    public String code() {
        return "basic";
    }

    @Override
    public String name() {
        return "账户名和密码";
    }

    @Override
    public Class<BasicAuthProperty> propertyClass() {
        return BasicAuthProperty.class;
    }

    @Override
    public AuthResult authenticate(BasicAuthProperty property) {
        String token = null;
        try {
            token = AuthorizationUtil.encodeBasicAuth(property.getUsername(), property.getPassword());
        } catch (IOException e) {
            throw new RuntimeException("加密账户名和密码异常", e);
        }

        AuthResult result = new AuthResult();
        result.setTokenPosition(TokenPositionEnum.HEADER);
        result.setTokenName("Authorization");
        result.setTokenValue(token);
        result.setTtl(null);
        result.setExtra(Collections.emptyMap());

        return result;
    }
}
