package com.elitescloud.boot.auth.factory.provider.properties;

import com.elitescloud.boot.auth.factory.common.BaseAuthProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 集成父级的属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/26 周一
 */
public class InheritAuthProperty extends BaseAuthProperty {
    private static final long serialVersionUID = -646901811463960349L;

    /**
     * 继承的请求头
     */
    private List<String> headers = List.of("Authorization", "Access-Token");

    /**
     * 继承的请求参数
     */
    private List<String> queryParams = new ArrayList<>(0);

    /**
     * 继承的Cookie
     */
    private List<String> cookies = new ArrayList<>(0);

    public List<String> getHeaders() {
        return headers;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public List<String> getQueryParams() {
        return queryParams;
    }

    public void setQueryParams(List<String> queryParams) {
        this.queryParams = queryParams;
    }

    public List<String> getCookies() {
        return cookies;
    }

    public void setCookies(List<String> cookies) {
        this.cookies = cookies;
    }
}
