/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.factory.provider;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.factory.common.AuthClientProvider;
import com.elitescloud.boot.auth.factory.common.AuthResult;
import com.elitescloud.boot.auth.factory.common.constant.TokenPositionEnum;
import com.elitescloud.boot.auth.factory.provider.properties.InheritAuthProperty;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InheritAuthClientProvider
implements AuthClientProvider<InheritAuthProperty> {
    private static final Logger logger = LoggerFactory.getLogger(InheritAuthClientProvider.class);

    @Override
    public String code() {
        return "inherit";
    }

    @Override
    public String name() {
        return "\u4ece\u7236\u7ea7\u7ee7\u627f";
    }

    @Override
    public Class<InheritAuthProperty> propertyClass() {
        return InheritAuthProperty.class;
    }

    @Override
    public AuthResult authenticate(InheritAuthProperty property) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            logger.info("\u5f53\u524d\u8bf7\u6c42\u4e3a\u7a7a\uff0c\u65e0\u9700\u7ee7\u627f\u8ba4\u8bc1");
            return null;
        }
        AuthResult result = new AuthResult();
        result.setExtra(new HashMap<String, Object>(4));
        if (CollUtil.isNotEmpty(property.getHeaders())) {
            result.setTokenPosition(TokenPositionEnum.HEADER);
            if (property.getHeaders().size() == 1) {
                String header = property.getHeaders().get(0);
                result.setTokenName(header);
                result.setTokenValue(request.getHeader(header));
            } else {
                HashMap<String, String> headers = new HashMap<String, String>(property.getHeaders().size());
                for (String header : property.getHeaders()) {
                    headers.put(header, request.getHeader(header));
                }
                result.getExtra().put("_headers", headers);
            }
            return result;
        }
        if (CollUtil.isNotEmpty(property.getQueryParams())) {
            result.setTokenPosition(TokenPositionEnum.QUERY);
            if (property.getQueryParams().size() == 1) {
                String queryParam = property.getQueryParams().get(0);
                result.setTokenName(queryParam);
                result.setTokenValue(request.getParameter(queryParam));
            } else {
                HashMap<String, String> queryParams = new HashMap<String, String>(property.getQueryParams().size());
                for (String queryParam : property.getQueryParams()) {
                    queryParams.put(queryParam, request.getParameter(queryParam));
                }
                result.getExtra().put("_query", queryParams);
            }
            return result;
        }
        if (CollUtil.isNotEmpty(property.getCookies())) {
            result.setTokenPosition(TokenPositionEnum.COOKIE);
            if (property.getCookies().size() == 1) {
                for (Cookie cookie : request.getCookies()) {
                    if (!CharSequenceUtil.equals((CharSequence)cookie.getName(), (CharSequence)property.getCookies().get(0))) continue;
                    result.setTokenName(cookie.getName());
                    result.setTokenValue(cookie.getValue());
                    break;
                }
            } else {
                HashMap<String, String> cookies = new HashMap<String, String>(property.getCookies().size());
                for (Cookie cookie : request.getCookies()) {
                    if (!property.getCookies().contains(cookie.getName())) continue;
                    cookies.put(cookie.getName(), cookie.getValue());
                }
                result.getExtra().put("_cookies", cookies);
            }
            return result;
        }
        logger.error("\u6682\u4e0d\u652f\u6301\u7684\u7ee7\u627f\u7c7b\u578b");
        return null;
    }
}

