package com.elitescloud.boot.auth.factory.common;

import com.elitescloud.boot.auth.factory.common.constant.TokenPositionEnum;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;

/**
 * 认证结果.
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/23 周五
 */
public class AuthResult implements Serializable {
    private static final long serialVersionUID = 624709479641700702L;

    /**
     * 令牌位置.
     */
    private TokenPositionEnum tokenPosition;

    /**
     * 令牌名称.
     */
    private String tokenName;

    /**
     * 令牌值.
     */
    private String tokenValue;

    /**
     * 令牌有效时间.
     */
    private Duration ttl;

    /**
     * 扩展属性
     */
    private Map<String, Object> extra;

    public TokenPositionEnum getTokenPosition() {
        return tokenPosition;
    }

    public void setTokenPosition(TokenPositionEnum tokenPosition) {
        this.tokenPosition = tokenPosition;
    }

    public String getTokenName() {
        return tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public String getTokenValue() {
        return tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public Duration getTtl() {
        return ttl;
    }

    public void setTtl(Duration ttl) {
        this.ttl = ttl;
    }

    public Map<String, Object> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }
}
