package com.elitescloud.boot.auth.factory.common.constant;

/**
 * 令牌位置.
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/23 周五
 */
public enum TokenPositionEnum {
    HEADER("请求头"),
    QUERY("查询参数"),
    BODY("请求体"),
    COOKIE("Cookie"),
    OTHER("其它"),
    ;

    private final String description;

    TokenPositionEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public static TokenPositionEnum getByValue(String value) {
        if (value == null) {
            return null;
        }
        for (TokenPositionEnum v : values()) {
            if (v.name().equals(value)) {
                return v;
            }
        }
        return null;
    }

    public static String getDescription(String value) {
        if (value == null) {
            return null;
        }
        for (TokenPositionEnum v : values()) {
            if (v.name().equals(value)) {
                return v.getDescription();
            }
        }
        return null;
    }
}
