/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.auth.factory.provider;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.factory.common.AuthClientProvider;
import com.elitescloud.boot.auth.factory.common.AuthResult;
import com.elitescloud.boot.auth.factory.common.constant.TokenPositionEnum;
import com.elitescloud.boot.auth.factory.provider.properties.OAuth2AuthProperty;
import com.elitescloud.boot.util.RestTemplateFactory;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class OAuth2AuthClientProvider
implements AuthClientProvider<OAuth2AuthProperty> {
    private final RestTemplate restTemplate = RestTemplateFactory.instance();

    @Override
    public String code() {
        return "OAuth2";
    }

    @Override
    public String name() {
        return "OAuth2";
    }

    @Override
    public Class<OAuth2AuthProperty> propertyClass() {
        return OAuth2AuthProperty.class;
    }

    @Override
    public AuthResult authenticate(OAuth2AuthProperty property) {
        Assert.notBlank((CharSequence)property.getTokenUrl(), (String)"tokenUrl\u4e3a\u7a7a", (Object[])new Object[0]);
        LinkedMultiValueMap postParam = new LinkedMultiValueMap(8);
        postParam.add((Object)"grant_type", (Object)"client_credentials");
        postParam.add((Object)"client_id", (Object)property.getClientId());
        postParam.add((Object)"client_secret", (Object)property.getClientSecret());
        ResponseEntity authResult = null;
        try {
            authResult = this.restTemplate.exchange(property.getTokenUrl(), HttpMethod.POST, new HttpEntity((Object)postParam, null), (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u8ba4\u8bc1Token\u5f02\u5e38", e);
        }
        if (authResult.getBody() == null) {
            throw new RuntimeException("\u83b7\u53d6\u8ba4\u8bc1Token\u5931\u8d25\uff1a" + String.valueOf(authResult.getStatusCode()));
        }
        Map tokenResult = (Map)authResult.getBody();
        AuthResult result = new AuthResult();
        result.setTokenPosition(TokenPositionEnum.HEADER);
        result.setTokenName("Authorization");
        result.setTokenValue(tokenResult.getOrDefault("token_type", "Bearer").toString() + " " + tokenResult.getOrDefault("access_token", "").toString());
        int ttl = Integer.parseInt(((Object)tokenResult.getOrDefault("expires_in", 0)).toString());
        result.setTtl(Duration.ofSeconds(ttl));
        result.setExtra(Collections.emptyMap());
        return result;
    }
}

