package com.elitescloud.boot.auth.provider.cas;

import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;

/**
 * 统一身份认证用户处理转换.
 * <p>
 * 统一身份认证的用户与本系统的用户信息转换
 *
 * @author Kaiser（wang shao）
 * @date 2/13/2023
 */
public interface CasUserResolver {

    /**
     * 处理用户信息
     *
     * @param userInfoDTO 统一认证服务的用户信息
     * @return 系统中的用户ID
     */
    Long resolve(AuthUserDTO userInfoDTO);
}
