package com.elitescloud.boot.auth.provider.config;

import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.tool.RedisHelper;
import com.elitescloud.boot.auth.provider.config.system.ConfigProperties;
import com.elitescloud.boot.auth.provider.config.system.WechatProperties;
import com.elitescloud.boot.auth.provider.controller.LoginSupportController;
import com.elitescloud.boot.auth.provider.provider.CaptchaProvider;
import com.elitescloud.boot.auth.provider.provider.LoginSupportProvider;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatManager;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatProvider;
import com.elitescloud.boot.auth.provider.provider.wechat.WechatTemplate;
import com.elitescloud.boot.core.CloudtCoreAutoConfiguration;
import com.elitescloud.boot.exception.BusinessException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * 可选登录扩展支持配置.
 * <p>
 * 根据登录认证方式选择
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/6
 */
@ConditionalOnClass({CloudtCoreAutoConfiguration.class})
public class LoginSupportConfig {

    private final AuthorizationProperties authorizationProperties;
    private final ConfigProperties configProperties;

    public LoginSupportConfig(AuthorizationProperties authorizationProperties, ConfigProperties configProperties) {
        this.authorizationProperties = authorizationProperties;
        this.configProperties = configProperties;
    }

    /**
     * 登录基础支持服务
     *
     * @return
     */
    @Bean
    public LoginSupportProvider loginSupportProvider() {
        return new LoginSupportProvider(configProperties);
    }

    /**
     * 登录相关基础支持服务接口
     *
     * @param loginSupportProvider
     * @return
     */
    @Bean
    public LoginSupportController commonLoginSupportController(LoginSupportProvider loginSupportProvider) {
        return new LoginSupportController(loginSupportProvider);
    }

    /**
     * 验证码相关服务
     *
     * @param redisHelper
     * @return
     */
    @Bean
    public CaptchaProvider captchaProvider(RedisHelper redisHelper) {
        return new CaptchaProvider(redisHelper);
    }

    /**
     * 微信相关服务
     *
     * @param wechatProperties
     * @return
     */
    @Bean
    public WechatProvider wechatProvider(WechatProperties wechatProperties) {
        return new WechatProvider(wechatProperties);
    }

    /**
     * 微信相关服务
     *
     * @param redisHelper
     * @return
     */
    @Bean
    public WechatTemplate wechatTemplate(RedisHelper redisHelper, WechatManager wechatManager) {
        return new WechatTemplate(wechatManager::getAppSecret, redisHelper);
    }

    @Bean
    @ConditionalOnMissingBean
    public WechatManager wechatManagerDefault() {
        return appId -> {
            throw new BusinessException("暂无实现");
        };
    }
}
