package com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer;

import com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer.filter.OAuth2AuthorizationCodeStateAuthenticationFilter;
import com.elitescloud.boot.auth.resolver.UniqueRequestResolver;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationEndpointFilter;

/**
 * 对于不支持redirect功能的终端支持通过state维持认证前后状态.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/4
 */
public class OAuth2AuthorizationCodeStateFilterSecurityConfigurer<H extends HttpSecurityBuilder<H>>
        extends AbstractHttpConfigurer<OAuth2AuthorizationCodeStateFilterSecurityConfigurer<H>, H> {

    private final AuthorizationServerSettings authorizationServerSettings;

    private UniqueRequestResolver uniqueRequestResolver;

    public OAuth2AuthorizationCodeStateFilterSecurityConfigurer(AuthorizationServerSettings authorizationServerSettings) {
        this.authorizationServerSettings = authorizationServerSettings;
    }

    @Override
    public void init(H http) throws Exception {
        super.init(http);
    }

    @Override
    public void configure(H http) throws Exception {
        OAuth2AuthorizationService authorizationService = http.getSharedObject(OAuth2AuthorizationService.class);
        OAuth2AuthorizationCodeStateAuthenticationFilter authenticationFilter = new OAuth2AuthorizationCodeStateAuthenticationFilter(authorizationServerSettings.getAuthorizationEndpoint(), authorizationService);
        http.addFilterBefore(authenticationFilter, OAuth2AuthorizationEndpointFilter.class);

        if (uniqueRequestResolver != null) {
            authenticationFilter.setUniqueRequestResolver(uniqueRequestResolver);
        }

        super.configure(http);
    }

    public OAuth2AuthorizationCodeStateFilterSecurityConfigurer<H> uniqueRequestResolver(UniqueRequestResolver uniqueRequestResolver) {
        this.uniqueRequestResolver = uniqueRequestResolver;
        return this;
    }
}
