package com.elitescloud.boot.auth.provider.config.servlet.oauth2.configurer.filter;

import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

/**
 * OAuth2父类.
 *
 * @author Kaiser（wang shao）
 * @date 3/1/2023
 */
abstract class AbstractOAuth2Filter extends OncePerRequestFilter {

    protected boolean isPrincipalAuthenticated(Authentication principal) {
        return principal != null &&
                !AnonymousAuthenticationToken.class.isAssignableFrom(principal.getClass()) &&
                principal.isAuthenticated();
    }

    protected RequestMatcher buildOAuth2AuthorizationEndpointRequestMatcher(String oauth2Authorizationendpoint) {
        return new OrRequestMatcher(
                new AntPathRequestMatcher(
                        oauth2Authorizationendpoint,
                        HttpMethod.GET.name()),
                new AntPathRequestMatcher(
                        oauth2Authorizationendpoint,
                        HttpMethod.POST.name()));
    }
}
