package com.elitescloud.boot.auth.provider.provider.user;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.UserDetailManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户管理器父类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/5
 */
@Log4j2
public abstract class AbstractUserDetailManager implements UserDetailManager {
    protected final AuthorizationProperties authorizationProperties;

    protected TenantClientProvider tenantClientProvider;

    protected AbstractUserDetailManager(AuthorizationProperties authorizationProperties) {
        this.authorizationProperties = authorizationProperties;
    }

    @Override
    public GeneralUserDetails loadUserByUsername(String username) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserByMobile(String mobile) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserByEmail(String email) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserById(String userId) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserByAccount(String account) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    @Override
    public GeneralUserDetails loadUserByWechatOpenid(String wechatOpenid) {
        throw new AuthorizationException("暂不支持的认证方式");
    }

    /**
     * userDto转GeneralUserDetails
     *
     * @param user 用户信息
     * @return 用户信息
     */
    protected GeneralUserDetails wrapUserDetails(SysUserDTO user) {
        // 处理角色编码前缀
        var rolePrefix = authorizationProperties.getRolePrefix();
        if (!CollectionUtils.isEmpty(user.getRoleCodes()) && StringUtils.hasText(rolePrefix)) {
            var codes = user.getRoleCodes().stream()
                    .map(t -> t.startsWith(rolePrefix) ? t : rolePrefix + t)
                    .collect(Collectors.toSet());
            user.setRoleCodes(codes);
        }

        if (user.getTenantId() == null) {
            user.setTenantId(TenantConstant.DEFAULT_TENANT_ID);
        }
        user.setRoleCodes(Collections.unmodifiableSet(ObjectUtil.defaultIfNull(user.getRoleCodes(), Collections.emptySet())));
        user.setRoleIds(Collections.unmodifiableSet(ObjectUtil.defaultIfNull(user.getRoleIds(), Collections.emptySet())));
        user.setTerminals(Collections.unmodifiableList(ObjectUtil.defaultIfNull(user.getTerminals(), Collections.emptyList())));
        user.setOrgList(Collections.unmodifiableList(ObjectUtil.defaultIfNull(user.getOrgList(), Collections.emptyList())));

        if (user.getSysTenantVO() == null && (tenantClientProvider != null && tenantClientProvider.enabledTenant())) {
            var tenant = tenantClientProvider.getCurrentTenant();
            if (tenant != null) {
                user.setSysTenantVO(tenant);
                user.setSysTenantDTOList(Collections.singletonList(tenant));
            }
        }

        return new GeneralUserDetails(user);
    }

    @Autowired
    public void setTenantClientProvider(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }
}
